/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioPriorityField;
import filenet.sim.api.VWScenarioQueueAssignment;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class VWSIMQueuePriorityAddRemovePanel
extends VWAddRemovePanel
implements ListSelectionListener,
ActionListener {
    private JPanel m_orderPanel = null;
    private JRadioButton m_ascendingRadioButton = null;
    private JRadioButton m_descendingRadioButton = null;
    private VWSIMPropertyData m_propertyData = null;
    private Vector m_availableFieldNames = null;
    private Vector m_selectedFieldNames = null;
    private String m_selectedQueueName = null;
    private VWScenarioQueueAssignment m_queueAssignment = null;

    public VWSIMQueuePriorityAddRemovePanel(VWSIMPropertyData propertyData, JPanel orderPanel) {
        super(58, orderPanel);
        this.enableSorting(1280);
        this.setAvailableItemName(VWSIMResource.s_availableQueuePriority);
        this.setSelectedItemName(VWSIMResource.s_selectedQueuePriority);
        this.m_orderPanel = orderPanel;
        this.initControls();
        this.m_availableList.addListSelectionListener(this);
        this.m_propertyData = propertyData;
        this.m_availableFieldNames = new Vector();
        this.m_selectedFieldNames = new Vector();
    }

    public void reinitialize(String queueName, VWScenarioQueueAssignment queueAssignment) {
        try {
            this.removeAllResourceNames();
            this.m_selectedQueueName = queueName;
            this.m_queueAssignment = queueAssignment;
            if (queueName != null && queueAssignment != null) {
                int count;
                VWScenarioPriorityField[] fields;
                int fieldCount;
                VWExposedFieldDefinition[] fieldDefs;
                VWQueueDefinition queueDef;
                VWQueue queue;
                VWSession session = this.m_propertyData.getVWSession();
                if (session != null && this.m_selectedQueueName != null && (queue = session.getQueue(this.m_selectedQueueName)) != null && (queueDef = queue.fetchQueueDefinition()) != null && (fieldDefs = queueDef.getFields()) != null && (fieldCount = fieldDefs.length) > 0) {
                    for (int i = 0; i < fieldCount; ++i) {
                        String fieldName = fieldDefs[i].getName();
                        if (fieldName.startsWith("F_")) continue;
                        this.m_availableFieldNames.addElement(fieldDefs[i].getName());
                    }
                }
                if ((fields = this.m_queueAssignment.getPriorityFields()) != null && (count = fields.length) > 0) {
                    int i;
                    for (i = 0; i < count; ++i) {
                        this.m_selectedFieldNames.addElement(fields[i].getName());
                    }
                    for (i = 0; i < count; ++i) {
                        String name = fields[i].getName();
                        if (this.m_availableFieldNames.contains(name)) continue;
                        this.m_availableFieldNames.addElement(name);
                    }
                }
            }
            this.initializeLists(this.m_availableFieldNames.toArray(), this.m_selectedFieldNames.toArray());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.m_ascendingRadioButton.setEnabled(false);
        this.m_descendingRadioButton.setEnabled(false);
    }

    public void valueChanged(ListSelectionEvent event) {
        super.valueChanged(event);
        try {
            if (event.getSource() == this.m_selectedList && !event.getValueIsAdjusting()) {
                boolean enable = false;
                int[] indices = this.m_selectedList.getSelectedIndices();
                if (indices != null && indices.length == 1) {
                    enable = true;
                    String fieldName = (String)this.m_selectedList.getSelectedValue();
                    VWScenarioPriorityField field = this.m_queueAssignment.getPriorityField(fieldName);
                    int order = field.getOrderType();
                    switch (order) {
                        case 1: {
                            this.m_ascendingRadioButton.removeActionListener(this);
                            this.m_ascendingRadioButton.setSelected(true);
                            this.m_ascendingRadioButton.addActionListener(this);
                            break;
                        }
                        case 2: {
                            this.m_descendingRadioButton.removeActionListener(this);
                            this.m_descendingRadioButton.setSelected(true);
                            this.m_descendingRadioButton.addActionListener(this);
                        }
                    }
                }
                this.m_ascendingRadioButton.setEnabled(enable);
                this.m_descendingRadioButton.setEnabled(enable);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        Object src = event.getSource();
        if (src == this.m_ascendingRadioButton) {
            this.performAscendingRadioButton();
        } else if (src == this.m_descendingRadioButton) {
            this.performDescendingRadioButton();
        }
    }

    protected void moveSelectedItemsUp() {
        super.moveSelectedItemsUp();
        try {
            this.m_queueAssignment.reorderPriorityFields(this.getPrioritiesFromSelectedList());
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void moveSelectedItemsDown() {
        super.moveSelectedItemsDown();
        try {
            this.m_queueAssignment.reorderPriorityFields(this.getPrioritiesFromSelectedList());
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void onAddItemsAction(Object[] items) {
        try {
            int fieldCount;
            VWExposedFieldDefinition[] fieldDefs;
            VWQueueDefinition queueDef;
            VWQueue queue;
            VWSession session;
            int count;
            super.onAddItemsAction(items);
            if (items != null && (count = items.length) > 0 && (session = this.m_propertyData.getVWSession()) != null && (queue = session.getQueue(this.m_selectedQueueName)) != null && (queueDef = queue.fetchQueueDefinition()) != null && (fieldDefs = queueDef.getFields()) != null && (fieldCount = fieldDefs.length) > 0) {
                block2: for (int i = 0; i < count; ++i) {
                    int type = 1;
                    String fieldName = (String)items[i];
                    for (int j = 0; j < fieldCount; ++j) {
                        if (VWStringUtils.compare(fieldName, fieldDefs[j].getName()) != 0) continue;
                        type = fieldDefs[j].getFieldType();
                        this.m_queueAssignment.createPriorityField(fieldName, type, 1);
                        continue block2;
                    }
                }
                this.m_propertyData.setDirty();
            }
            boolean enable = false;
            if (items != null && items.length == 1) {
                enable = true;
                this.m_ascendingRadioButton.removeActionListener(this);
                this.m_ascendingRadioButton.setSelected(true);
                this.m_ascendingRadioButton.addActionListener(this);
            }
            this.m_ascendingRadioButton.setEnabled(enable);
            this.m_descendingRadioButton.setEnabled(enable);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        try {
            int count;
            super.onRemoveItemsAction(items);
            if (items != null && (count = items.length) > 0) {
                for (int i = 0; i < count; ++i) {
                    this.m_queueAssignment.deletePriorityField((String)items[i]);
                }
                this.m_propertyData.setDirty();
            }
            boolean enable = false;
            this.m_ascendingRadioButton.setEnabled(enable);
            this.m_descendingRadioButton.setEnabled(enable);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }

    private void initControls() {
        this.m_orderPanel.setLayout(new GridLayout(1, 2));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_ascendingRadioButton = new JRadioButton(VWSIMResource.s_ascendingOrder);
        this.m_ascendingRadioButton.setSelected(true);
        this.m_ascendingRadioButton.setEnabled(false);
        buttonGroup.add(this.m_ascendingRadioButton);
        this.m_ascendingRadioButton.addActionListener(this);
        this.m_orderPanel.add(this.m_ascendingRadioButton);
        this.m_descendingRadioButton = new JRadioButton(VWSIMResource.s_descendingOrder);
        this.m_descendingRadioButton.setSelected(false);
        this.m_descendingRadioButton.setEnabled(false);
        buttonGroup.add(this.m_descendingRadioButton);
        this.m_descendingRadioButton.addActionListener(this);
        this.m_orderPanel.add(this.m_descendingRadioButton);
    }

    private void performAscendingRadioButton() {
        try {
            int index = this.m_selectedList.getSelectedIndex();
            if (index != -1) {
                String fieldName = (String)this.m_selectedList.getSelectedValue();
                VWScenarioPriorityField field = this.m_queueAssignment.getPriorityField(fieldName);
                field.setOrderType(1);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performDescendingRadioButton() {
        try {
            int index = this.m_selectedList.getSelectedIndex();
            if (index != -1) {
                String fieldName = (String)this.m_selectedList.getSelectedValue();
                VWScenarioPriorityField field = this.m_queueAssignment.getPriorityField(fieldName);
                field.setOrderType(2);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void removeAllResourceNames() {
        this.m_availableList.removeAll();
        this.m_selectedList.removeAll();
        if (this.m_availableFieldNames != null) {
            this.m_availableFieldNames.removeAllElements();
        }
        if (this.m_selectedFieldNames != null) {
            this.m_selectedFieldNames.removeAllElements();
        }
    }

    private String[] getPrioritiesFromSelectedList() {
        String[] priorities = null;
        try {
            ListModel listModel = this.m_selectedList.getModel();
            int count = listModel.getSize();
            priorities = new String[count];
            for (int i = 0; i < count; ++i) {
                priorities[i] = (String)listModel.getElementAt(i);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return priorities;
    }
}

